# define the orca transition matrix
L = matrix(c(0,      0.0043, 0.1132, 0, 
             0.9775, 0.9111, 0,      0,
             0,      0.0736, 0.9534, 0,
             0,      0,      0.0452, 0.9804),4,4,byrow=T)
# define the initial state
v0 = c(10,80,40,20)
# specify the number of time steps to project
t_max = 50
# create a matrix to store the results
v_all = matrix(NA,length(v0),t_max+1)
# populate the first column of the matrix with initial state
v_all[,1] = v0
# set the vector v to the initial state
v = v0

# iterate over each time step, updating population vector v
# at each step and storing the results to our matrix v_all
for ( t in 1:t_max )
  {
  v = L%*%v
  v_all[,t+1] = v
  }

# plot the results
matplot(0:t_max,t(v_all),type='o',pch=19,xlab='t',
        ylab='Population size')
